/**
 * \par Copyright (C), 2012-2016, MakeBlock
 * \class MeTouchSensor
 * \brief   Driver for Me touch sensor device.
 * @file    MeTouchSensor.h
 * @author  MakeBlock
 * @version V1.0.0
 * @date    2015/09/07
 * @brief   Header for for MeTouchSensor.cpp module
 *
 * \par Copyright
 * This software is Copyright (C), 2012-2016, MakeBlock. Use is subject to license \n
 * conditions. The main licensing options available are GPL V2 or Commercial: \n
 *
 * \par Open Source Licensing GPL V2
 * This is the appropriate option if you want to share the source code of your \n
 * application with everyone you distribute it to, and you also want to give them \n
 * the right to share who uses it. If you wish to use this software under Open \n
 * Source Licensing, you must contribute all your source code to the open source \n
 * community in accordance with the GPL Version 2 when your application is \n
 * distributed. See http://www.gnu.org/copyleft/gpl.html
 *
 * \par Description
 * This file is a drive for Me touch sensor device, It supports touch sensor
 * provided by the MakeBlock.
 *
 * \par Method List:
 *
 *    1. void MeTouchSensor::setpin(uint8_t ShotPin, uint8_t FocusPin)
 *    2. bool MeTouchSensor::touched()
 *    3. void MeTouchSensor::SetTogMode(uint8_t TogMode)
 *
 * \par History:
 * <pre>
 * `<Author>`         `<Time>`        `<Version>`        `<Descr>`
 * Mark Yan         2015/09/07     1.0.0            Rebuild the old lib.
 * </pre>
 *
 */
#ifndef MeTouchSensor_H
#define MeTouchSensor_H

#include <stdint.h>
#include <stdbool.h>
#include <Arduino.h>
#include "MeConfig.h"


/**
 * Class: MeTouchSensor
 * \par Description
 * Declaration of Class MeTouchSensor.
 */

#define TOUCHID_INTER_MODE
#define TOUCHID_VALID_DURATION 100


#ifdef __cplusplus
extern "C" {
#endif

#ifdef TOUCHID_INTER_MODE

extern void OnTouchIDTimer(void);

#endif


extern uint8_t GetTouchID(uint8_t bRight);

#ifdef __cplusplus
}
#endif


#endif

