// ActionScript file
package cc.makeblock.mimicar.uiwidgets
{
	import com.google.analytics.debug.Layout;
	
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filesystem.File;
	import flash.net.FileFilter;
	import flash.utils.ByteArray;
	import flash.utils.getDefinitionByName;
	import flash.utils.setTimeout;
	
	import assets.Resources;
	
	import cc.makeblock.mbot.util.PopupUtil;
	import cc.makeblock.util.HexUtil;
	
	import extensions.SerialManager;
	
	import org.aswing.ASColor;
	import org.aswing.ASFont;
	import org.aswing.AsWingConstants;
	import org.aswing.AsWingUtils;
	import org.aswing.AssetIcon;
	import org.aswing.BorderLayout;
	import org.aswing.CenterLayout;
	import org.aswing.DefaultListTextCellFactory;
	import org.aswing.EmptyLayout;
	import org.aswing.Insets;
	import org.aswing.JButton;
	import org.aswing.JFrame;
	import org.aswing.JFrameTitleBar;
	import org.aswing.JLabel;
	import org.aswing.JList;
	import org.aswing.JPanel;
	import org.aswing.SoftBoxLayout;
	import org.aswing.SolidBackground;
	import org.aswing.border.EmptyBorder;
	import org.aswing.event.AWEvent;
	import org.aswing.geom.IntDimension;
	import org.aswing.geom.IntRectangle;
	
	import translation.Translator;
	
	import uiwidgets.IconButton;

	public class DeviceDebug extends JFrame
	{
		[Embed("/assets/UI/buttons/touch_leftOff.png")]
		static private const touch_leftOff:Class;

		[Embed("/assets/UI/buttons/touch_rightOff.png")]
		static private const touch_rightOff:Class;

		[Embed("/assets/UI/buttons/TS_BS_On.png")]
		static private const ts_bs_on:Class;

		[Embed("/assets/UI/buttons/wallbarrier_leftOff.png")]
		static private const wallbarrier_leftOff:Class;

		[Embed("/assets/UI/buttons/wallbarrier_rightOff.png")]
		static private const wallbarrier_rightOff:Class;

		[Embed("/assets/UI/buttons/wallbarrier_upOff.png")]
		static private const wallbarrier_upOff:Class;

		[Embed("/assets/UI/buttons/audio.png")]
		static private const audio:Class;

		[Embed("/assets/UI/buttons/audio_tag.png")]
		static private const audio_tag:Class;

		[Embed("/assets/UI/buttons/audio_on.png")]
		static private const audio_on:Class;

		[Embed("/assets/UI/buttons/audio_off.png")]
		static private const audio_off:Class;

		[Embed("/assets/UI/buttons/color_left.png")]
		static private const color_left:Class;

		[Embed("/assets/UI/buttons/color_tag.png")]
		static private const color_tag:Class;

		[Embed("/assets/UI/buttons/color_right.png")]
		static private const color_right:Class;

		[Embed("/assets/UI/buttons/touchsensor.png")]
		static private const touch_senser:Class;

		[Embed("/assets/UI/buttons/barrier_sensor.png")]
		static private const barrier_sensor:Class;

		[Embed("/assets/UI/buttons/debug_bg.png")]
		static private const debug_bg:Class;

		//private var extList:JList;
		private var panel:JPanel;

		private var btnAdd:JButton;
		private var btnRemove:JButton;
		private var ibtntouch_left:JButton;
		private var ibtntouch_right:JButton;
		private var ibtnwallbarrier_left:JButton;
		private var ibtnwallbarrier_right:JButton;
		private var ibtnwallbarrier_up:JButton;
		private var ibtnaudio:JButton;
		private var ibtnaudio_tag:JButton;
		private var ibtnaudio_switch:JButton;
		private var ibtncolor_left:JButton;
		private var ibtncolor_left_tag:JButton;
		private var ibtncolor_right:JButton;
		private var ibtncolor_right_tag:JButton;
		private var label_audio:JLabel;
		private var label_color:JLabel;
		private var label_color_left:JLabel;
		private var label_color_right:JLabel;
		private var label_color_left_num:JLabel;
		private var label_color_right_num:JLabel;
		private var label_touch_bg:JLabel;
		private var label_touch:JLabel;
		private var label_barrier_sensor_bg:JLabel;
		private var label_audio_num:JLabel;
		private var label_audio_switch:JLabel;
		private var _iqcar:IQCar;
		public var s_x:int;
		public var s_y:int;
		public function DeviceDebug(iqcar:IQCar, owner:*=null)
		{
			super(owner, Translator.map("Mini-Q check"), false);
			defaultCloseOperation = JFrame.DISPOSE_ON_CLOSE;
			setResizable(false);
			PopupUtil.centerFrameTitle(this);
			_iqcar = iqcar;
			//setOpaque( false);
			//btnList = new JPanel(new SoftBoxLayout(SoftBoxLayout.X_AXIS, 190, SoftBoxLayout.X_AXIS));
			panel = new JPanel(new EmptyLayout());

			//panel.setBackgroundDecorator(new SolidBackground(new ASColor(0xAEEEEE)));

			label_touch_bg = new JLabel(null,  new AssetIcon(Resources.createBmp("debug_bg")));
			label_touch_bg.setBounds(new IntRectangle(0, 0, 750, 430));
			panel.append(label_touch_bg);

			label_touch_bg = new JLabel(null,  new AssetIcon(Resources.createBmp("touch_senser")));
			label_touch_bg.setBounds(new IntRectangle(10, 10, 250, 150));
			panel.append(label_touch_bg);

			label_touch = new JLabel(Translator.map("Touch Sensor"));
			label_touch.setBounds(new IntRectangle(50, 30, 150, 20));
			label_touch.setFont(new ASFont("微软雅黑",20));
			panel.append(label_touch);

			ibtntouch_left = new JButton(null, new AssetIcon(Resources.createBmp("touch_leftOff")));
			ibtntouch_left.setBounds(new IntRectangle(30, 65, 50, 50));
			panel.append(ibtntouch_left);

			ibtntouch_right = new JButton(null, new AssetIcon(Resources.createBmp("touch_rightOff")));
			ibtntouch_right.setBounds(new IntRectangle(180, 65, 50, 50));
			panel.append(ibtntouch_right);

			label_color = new JLabel(Translator.map("Left"));
			label_color.setBounds(new IntRectangle(5, 115, 100, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);

			label_color = new JLabel(Translator.map("Right"));
			label_color.setBounds(new IntRectangle(155, 115, 100, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);

			label_barrier_sensor_bg = new JLabel(null,  new AssetIcon(Resources.createBmp("barrier_sensor")));
			label_barrier_sensor_bg.setBounds(new IntRectangle(10, 170, 250, 211));
			panel.append(label_barrier_sensor_bg);

			label_touch = new JLabel(Translator.map("Barrier Sensor"));
			label_touch.setBounds(new IntRectangle(50, 185, 150, 20));
			label_touch.setFont(new ASFont("微软雅黑",20));
			panel.append(label_touch);
			/*
			ibtnwallbarrier_left = new JButton(null, new AssetIcon(new wallbarrier_leftOff()));
			ibtnwallbarrier_left.setBounds(new IntRectangle(30, 290, 50, 50));
			panel.append(ibtnwallbarrier_left);
			ibtnwallbarrier_right = new JButton(null, new AssetIcon(new wallbarrier_rightOff()));
			ibtnwallbarrier_right.setBounds(new IntRectangle(180, 290, 50, 50));
			panel.append(ibtnwallbarrier_right);
			ibtnwallbarrier_up = new JButton(null, new AssetIcon(new wallbarrier_upOff()));
			ibtnwallbarrier_up.setBounds(new IntRectangle(110, 220, 50, 50));
			panel.append(ibtnwallbarrier_up);
			
			label_color = new JLabel("Left");
			label_color.setBounds(new IntRectangle(5, 340, 100, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);
			
			label_color = new JLabel("Right");
			label_color.setBounds(new IntRectangle(155, 340, 100, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);
			
			label_color = new JLabel("Up");
			label_color.setBounds(new IntRectangle(85, 270, 100, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);
			
			*/
			ibtnwallbarrier_left = new JButton(null, new AssetIcon(Resources.createBmp("wallbarrier_leftOff")));
			ibtnwallbarrier_left.setBounds(new IntRectangle(130, 220, 50, 50));
			panel.append(ibtnwallbarrier_left);
			ibtnwallbarrier_right = new JButton(null, new AssetIcon(Resources.createBmp("wallbarrier_rightOff")));
			ibtnwallbarrier_right.setBounds(new IntRectangle(130, 290, 50, 50));
			panel.append(ibtnwallbarrier_right);

			label_color = new JLabel(Translator.map("Front"));
			label_color.setBounds(new IntRectangle(30, 235, 100, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);

			label_color = new JLabel(Translator.map("Back"));
			label_color.setBounds(new IntRectangle(30, 305, 100, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);

			ibtnaudio = new JButton(null, new AssetIcon(Resources.createBmp("audio")));
			ibtnaudio.setBounds(new IntRectangle(350, 50, 20, 250));
			panel.append(ibtnaudio);

			ibtnaudio_tag = new JButton(null, new AssetIcon(Resources.createBmp("audio_tag")));
			ibtnaudio_tag.setBounds(new IntRectangle(357, 55, 6, 0));//357, 55, 6, 237
			panel.append(ibtnaudio_tag);

			label_audio = new JLabel(Translator.map("Sound"));
			label_audio.setBounds(new IntRectangle(280, 320, 150, 20));
			label_audio.setFont(new ASFont("微软雅黑",18));
			panel.append(label_audio);

			label_audio_num = new JLabel(Translator.map("0"));
			label_audio_num.setBounds(new IntRectangle(320, 20, 80, 20));
			label_audio_num.setFont(new ASFont("微软雅黑",20));
			panel.append(label_audio_num);

			ibtnaudio_switch = new JButton(null, new AssetIcon(Resources.createBmp("audio_off")));
			ibtnaudio_switch.setBounds(new IntRectangle(357, 350, 21, 23));
			panel.append(ibtnaudio_switch);

			label_audio_switch = new JLabel(Translator.map("Peak hold"));
			label_audio_switch.setBounds(new IntRectangle(380, 350, 100, 21));
			label_audio_switch.setFont(new ASFont("微软雅黑",15));
			panel.append(label_audio_switch);

			ibtncolor_left = new JButton(null, new AssetIcon(Resources.createBmp("color_left")));
			ibtncolor_left.setBounds(new IntRectangle(450, 50, 20, 220));//450, 50, 20, 220
			panel.append(ibtncolor_left);

			ibtncolor_left_tag = new JButton(null, new AssetIcon(Resources.createBmp("color_tag")));
			ibtncolor_left_tag.setBounds(new IntRectangle(457, 55, 6, 0));//457, 55, 6, 209
			panel.append(ibtncolor_left_tag);

			ibtncolor_right = new JButton(null, new AssetIcon(Resources.createBmp("color_right")));
			ibtncolor_right.setBounds(new IntRectangle(550, 50, 20, 220));//550, 50, 20, 220
			panel.append(ibtncolor_right);

			ibtncolor_right_tag = new JButton(null, new AssetIcon(Resources.createBmp("color_tag")));
			ibtncolor_right_tag.setBounds(new IntRectangle(557, 55, 6, 0));//557, 55, 6, 209
			panel.append(ibtncolor_right_tag);

			label_color_left_num = new JLabel(" 0 ");
			label_color_left_num.setBounds(new IntRectangle(420, 20, 80, 20));
			label_color_left_num.setFont(new ASFont("微软雅黑",20));
			panel.append(label_color_left_num);

			label_color_right_num = new JLabel(" 0 ");
			label_color_right_num.setBounds(new IntRectangle(520, 20, 80, 20));
			label_color_right_num.setFont(new ASFont("微软雅黑",20));
			panel.append(label_color_right_num);

			label_color = new JLabel(Translator.map("Left"));
			label_color.setBounds(new IntRectangle(420, 280, 80, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);

			label_color = new JLabel(Translator.map("Right"));
			label_color.setBounds(new IntRectangle(520, 280, 80, 20));
			label_color.setFont(new ASFont("微软雅黑",16));
			panel.append(label_color);

			label_color = new JLabel(Translator.map("Trace"));
			label_color.setBounds(new IntRectangle(445, 320, 150, 20));
			label_color.setFont(new ASFont("微软雅黑",18));
			panel.append(label_color);

			getContentPane().append(panel);

			ibtnaudio_switch.addActionListener(_iqcar.meumPart.audio_switch_function);
	
			//pack();
			setSizeWH(630, 420);
		}

		public function audio_switch_remove_event():void
		{
		  ibtnaudio_switch.removeEventListener(MouseEvent.CLICK, debug_frame_exit);
		}

		private function debug_frame_exit():void
		{
		  
		}

		public function audio_switch_icon_translator(fAudioSwitch:Boolean):void
		{
			if (panel.visible == false) 
			{
				return;
			}

		   if (fAudioSwitch)
		   {
			   ibtnaudio_switch.setIcon(new AssetIcon(new audio_on()));
		   }
		   else
		   {
			   ibtnaudio_switch.setIcon(new AssetIcon(new audio_off()));
		   }
		}
		
		private var audio_p:int = 0;
		private var audio_pt:int = 0;
		private var audio_number:int = 0;
		private var audio_tag_count:int = 0;
		//357, 55, 5, 237
		private function audio_progressbar(tag:int):void
		{
			if (panel.visible == false) 
			{
				return;
			}

			//if (tag != audio_tag_count)
			//{
			//	_iqcar.log("audio_active  test1.");
			//    return;
			//}
			//trace("audio_progressbar:"+(ibtnaudio_tag.y + ibtnaudio_tag.height));
			if (audio_p < audio_pt)
			{
				audio_p++;
			}
			else if (audio_p > audio_pt)
			{
				audio_p--;
			}
			else
			{
				//_iqcar.log("audio_active  test2.");
			    return;
			}
			
			ibtnaudio_tag.y = 55+ (100-audio_p)*(237/100);
			ibtnaudio_tag.height = 292-ibtnaudio_tag.y;//audio_p*(237/100);
			
			if (audio_p != audio_pt)
			{
				//.log("audio_active  test3.");
				setTimeout(audio_progressbar, 100, tag);
			}
		}

		public function audio_active(fAudioSwitch:Boolean, audio_num:int):void
		{
			//_iqcar.log("audio_active");
			 if (fAudioSwitch && (audio_number > audio_num))
			 {
				_iqcar.log("audio_active  return."+fAudioSwitch.toString()+" " + audio_num + " "+audio_number);
			   return;
			 }

		     label_audio_num.setText(audio_num.toString());
			 audio_number = audio_num;
			 if (audio_number >= 4096)
			 {
				 audio_pt = 100;
			 }
			 else
			 {
				 audio_pt = ( audio_number*100)/4096;
			 }

			 if (audio_tag_count == 0x0fffffff)
			 {
			   audio_tag_count = 0;
			 }
			 audio_tag_count++;
			 setTimeout(audio_progressbar, 200, audio_tag_count);
		}

		private function ByteArray2Array(bytes:ByteArray):Array 
		{
			//var s:String = ""; 
			var arr:Array;
			bytes.position = 0; 
			while (bytes.bytesAvailable) 
			{
				arr.push(bytes.readByte());
				//s += "0x" + bytes.readByte().toString(16) + " ";
			}
			//if (s.length > 0) s = s.substr(0, s.length - 1); 
			//trace("bytes:", s, '\n'); 
			return arr;
		}
		/*
		private var recv_bytes:Array;
		private function recvData():void
		{
			var bytes:ByteArray;
			bytes = SerialManager.sharedManager().readBytes();
			if (bytes.length == 0)
			{
				setTimeout(recvData, 100);
				return;
			}
			
			bytes.position = 0;
			recv_bytes = ByteArray2Array(bytes);
			//bytes.readBytes(recv_bytes, recv_bytes.length, 0);
			
			parseMessage();
			setTimeout(recvData, 100);
		}*/

		
		
		private var fLeftTS:Boolean = false;
		private var fRightTS:Boolean = false;
		private var fFrontBS:Boolean = false;
		private var fBackBS:Boolean = false;
		public function sensor_active(cmd:int, fParam1:Boolean, fParam2:Boolean):void
		{
		  if (panel.visible == false)
		  {
		    return;
		  }
		  
		  switch(cmd)
		  {
		  case 0x15:
		  {
		    if (fParam1 != fLeftTS)
			{
				if (fParam1)
				{
					//ibtntouch_left.setIcon(new AssetIcon(new touch_leftOff()));
					ibtntouch_left.setIcon(new AssetIcon(new ts_bs_on()));
				}
				else
				{
					//ibtntouch_left.setIcon(new AssetIcon(new ts_bs_on()));

					ibtntouch_left.setIcon(new AssetIcon(new touch_leftOff()));
				}

				fLeftTS = fParam1;
			}

			if(fParam2 != fRightTS)
			{
				if (fParam2)
				{
					ibtntouch_right.setIcon(new AssetIcon(new ts_bs_on()));
				}
				else
				{
					ibtntouch_right.setIcon(new AssetIcon(new touch_leftOff()));
				}
				
				fRightTS = fParam2;
			}
		  }
			  break;
		  case 0x16:
		  {
			  if (fParam1 != fFrontBS)
			  {
				  if (fParam1)
				  {
					  ibtnwallbarrier_left.setIcon(new AssetIcon(new ts_bs_on()));
				  }
				  else
				  {
					  ibtnwallbarrier_left.setIcon(new AssetIcon(new touch_leftOff()));
				  }

				  fFrontBS = fParam1;
			  }
			  
			  if(fParam2 != fBackBS)
			  {
				  if (fParam2)
				  {
					  ibtnwallbarrier_right.setIcon(new AssetIcon(new ts_bs_on()));
				  }
				  else
				  {
					  ibtnwallbarrier_right.setIcon(new AssetIcon(new touch_leftOff()));
				  }

	    		  fBackBS = fParam2;
			  }
		  }
			  break;
		  default:
			  break;
		  }
		}
		
		private var LeftColorNum:int = 0;
	    private var RightColorNum:int = 0;
		public function ls_active(iLeftLS:int, iRightLS:int):void
		{
		  if (color_tag_num == 0x0fffffff)
		  {
			color_tag_num = 0;
		  }
		  color_tag_num++;

		  if (LeftColorNum != iLeftLS)
		  {
			  LeftColorNum = iLeftLS;
			  label_color_left_num.setText(LeftColorNum.toString());
			  if (LeftColorNum >= 1000)
			  {
				  cl_pt = 100;
			  }
			  else
			  {
				  cl_pt = (LeftColorNum*100)/1000;
			  }

			  setTimeout(color_left_progressbar, 100, color_tag_num);
		  }

		  if (RightColorNum != iRightLS)
		  {
			  RightColorNum = iRightLS;
			  label_color_right_num.setText(RightColorNum.toString());
			  if (RightColorNum >= 1000)
			  {
				  cr_pt = 100;
			  }
			  else
			  {
				  cr_pt = (RightColorNum*100)/1000;
			  }

			  setTimeout(color_right_progressbar, 100, color_tag_num);
		  }
		}

		private var cl_p:int = 0;
		private var cl_pt:int = 0;
		private var color_tag_num:int = 0;
		//357, 55, 5, 237
		private function color_left_progressbar(tag:int):void
		{
			if (panel.visible == false) 
			{
				return;
			}

			//if (tag != color_tag_num)
			//{
			//  return;
			//}

			if (cl_p < cl_pt)
			{
			  cl_p++;
			}
			else if (cl_p > cl_pt)
			{
			  cl_p--;
			}
			else
			{
			  return;
			}

			ibtncolor_left_tag.y = 55+ (100-cl_p)*(210/100);
			ibtncolor_left_tag.height = 264-ibtncolor_left_tag.y;//cl_p*(210/100);
			if (cl_p != cl_pt)
			{
				setTimeout(color_left_progressbar, 100, tag);
			}

			//redraw();
		}
		
		private var cr_p:int = 0;
		private var cr_pt:int = 0;
		//357, 55, 5, 237
		
		private function color_right_progressbar(tag:int):void
		{
			if (panel.visible == false) 
			{
				return;
			}
			
			//if (tag != color_tag_num)
			//{
            //  return;			
			//}

			if (cr_p < cr_pt)
			{
			  cr_p++;
			}
			else
			{
			  cr_p--;
			}
			
			ibtncolor_right_tag.y = 55+ (100-cr_p)*(210/100);
			ibtncolor_right_tag.height = 264-ibtncolor_right_tag.y;//cl_p*(210/100);
			
			if (cr_p != cr_pt)
			{
			   setTimeout(color_right_progressbar, 100, tag);
			}

			//redraw();
		}
		
		override public function show():void
		{
			//Translator.regChangeEvt(__onLangChanged);
			//updateList();
			AsWingUtils.centerLocate(this);
			super.show();
			//PopupUtil.disableRightMouseEvent();
			s_x = x;
			s_y = y;
		}
	}
}