/**
 * \par Copyright (C), 2012-2016, MakeBlock
 * \class MeRGBLed
 * \brief   Driver for W2812 full-color LED lights.
 * @file    MeRGBLed.h
 * @author  MakeBlock
 * @version V1.0.0
 * @date    2015/09/01
 * @brief   Header for MeRGBLed.cpp module
 *
 * \par Copyright
 * This software is Copyright (C), 2012-2016, MakeBlock. Use is subject to license \n
 * conditions. The main licensing options available are GPL V2 or Commercial: \n
 *
 * \par Open Source Licensing GPL V2
 * This is the appropriate option if you want to share the source code of your \n
 * application with everyone you distribute it to, and you also want to give them \n
 * the right to share who uses it. If you wish to use this software under Open \n
 * Source Licensing, you must contribute all your source code to the open source \n
 * community in accordance with the GPL Version 2 when your application is \n
 * distributed. See http://www.gnu.org/copyleft/gpl.html
 *
 * \par Description
 * this file is a drive for WS2811/2812 full-color LED lights, It supports
 * W2812B full-color LED lights device provided by the MakeBlock.
 *
 * \par Method List:
 *
 *    1. void MeRGBLed::reset(uint8_t port)
 *    2. void MeRGBLed::reset(uint8_t port,uint8_t slot)
 *    3. void MeRGBLed::setpin(uint8_t port)
 *    4. uint8_t MeRGBLed::getNumber()
 *    5. cRGB MeRGBLed::getColorAt(uint8_t index)
 *    6. bool MeRGBLed::setColorAt(uint8_t index, uint8_t red, uint8_t green, uint8_t blue)
 *    7. bool MeRGBLed::setColor(uint8_t index, uint8_t red, uint8_t green, uint8_t blue)
 *    8. bool MeRGBLed::setColor(uint8_t red, uint8_t green, uint8_t blue)
 *    9. bool MeRGBLed::setColor(uint8_t index, long value)
 *    10. void MeRGBLed::show()
 *
 * \par History:
 * <pre>
 * `<Author>`         `<Time>`        `<Version>`        `<Descr>`
 * Mark Yan         2015/09/01     1.0.0            Rebuild the old lib.
 * </pre>
 *
 */
#ifndef MeRGBLed_h
#define MeRGBLed_h
#include <stdint.h>
#include <stdbool.h>
#include <Arduino.h>
#include "MeConfig.h"

#ifdef ME_PORT_DEFINED
#include "MePort.h"
#endif // ME_PORT_DEFINED



/// @brief Class for RGB Led Module

#define RGB_VALUE(r,g,b) ((((uint32_t)(r))<<16) | (((uint32_t)(g))<<8) | (((uint32_t)(b))<<0))

#define R_VALUE(rgb) ((((uint32_t)(rgb))>>16) & 0xFF)
#define G_VALUE(rgb) ((((uint32_t)(rgb))>>8) & 0xFF)
#define B_VALUE(rgb) ((((uint32_t)(rgb))>>0) & 0xFF)

typedef enum
{
	COLOR_OFF_BLACK = RGB_VALUE(0,0,0),
	COLOR_RED = RGB_VALUE(255,0,0),
	COLOR_GREEN = RGB_VALUE(0,255,0),
	COLOR_BLUE = RGB_VALUE(0,0,255),
	COLOR_YELLOW = RGB_VALUE(255,255,0),
	COLOR_PURPLE = RGB_VALUE(255,0,255),
	COLOR_CYAN = RGB_VALUE(0,255,255),
	COLOR_WHITE = RGB_VALUE(255,255,255),
}Type_Color_e;

typedef enum
{
	COLOR_OFF_BLACK_INDEX = 0,
	COLOR_RED_INDEX,
	COLOR_GREEN_INDEX,
	COLOR_BLUE_INDEX,
	COLOR_YELLOW_INDEX,
	COLOR_PURPLE_INDEX,
	COLOR_CYAN_INDEX,
	COLOR_WHITE_INDEX,		
}Type_Color_Index;

#define TYPE_COLOR_NUM 8

#define RGB_PIN_INVALID 0xFF

/**
 * Class: MeRGBLed
 *
 * \par Description
 * Declaration of Class MeRGBLed
 */
class MeRGBLed
{
public:

  MeRGBLed(void);

  ~MeRGBLed(void);

  void reset(void);

  void setpin(uint8_t nRPin, uint8_t nGPin, uint8_t nBPin);

  bool setColor(uint32_t nRGBValue);

private:

    
	uint32_t nColor;

	bool bSetPined;

	uint8_t nRedPin;
	uint8_t nGreenPin;
	uint8_t nBluePin;

};


#ifdef __cplusplus
extern "C" {
#endif


extern void RGBLed_SetLeft(uint32_t nColor);

extern void RGBLed_SetRight(uint32_t nColor);

extern void RGBLed_SetLeftOff();

extern void RGBLed_SetRightOff();

extern void RGBLed_Set(uint8_t bRight, uint32_t nColorIndex);



#ifdef __cplusplus
}
#endif




#endif


