/*
 * Copyright (c) 2016
   Michael Blank
 
 * library to allow for Timer5 Interrupts 
 *  for SAMD processors, Arduino Zero and Arduino MKR 1000
 *
 *  based on the AudioZero library
 *
 * This file is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU General Public License version 2
 * or the GNU Lesser General Public License version 2.1, both as
 * published by the Free Software Foundation.
 */
	
#ifndef TIMER4_H
#define TIMER4_H


#include "Arduino.h"


typedef void(*voidFuncPtr)(void);


class Timer4Class
{
public:

	Timer4Class() ;
	void begin(uint16_t value);
	void start(void) ;
	void end();
    void attachInterrupt(voidFuncPtr);
	void tcConfigure(uint32_t rateKHZ);
private:
	bool tcIsSyncing(void);
	void tcStartCounter(void);
	void tcReset(void);
	void tcEnable(void);
	void tcDisable(void);

  
};

extern Timer4Class MyTimer4;

#ifdef __cplusplus
extern "C" {
#endif

extern uint32_t GetTimer4Count();

#ifdef __cplusplus
}
#endif



#endif





