/*
  Copyright (c) 2014-2015 Arduino LLC.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  See the GNU Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef _VARIANT_ARDUINO_ZERO_SAMDJ_
#define _VARIANT_ARDUINO_ZERO_SAMDJ_

// The definitions here needs a SAMD core >=1.6.6
#define ARDUINO_SAMD_VARIANT_COMPLIANCE 10606

/*----------------------------------------------------------------------------
 *        Definitions
 *----------------------------------------------------------------------------*/

/** Frequency of the board main oscillator */
#define VARIANT_MAINOSC		(32768ul)

/** Master clock frequency */
#define VARIANT_MCK			  (48000000ul)

/*----------------------------------------------------------------------------
 *        Headers
 *----------------------------------------------------------------------------*/

#include "WVariant.h"

#ifdef __cplusplus
#include "SERCOM.h"
#include "Uart.h"
#endif // __cplusplus

#ifdef __cplusplus
extern "C"
{
#endif // __cplusplus

/*----------------------------------------------------------------------------
 *        Pins
 *----------------------------------------------------------------------------*/

// Number of pins defined in PinDescription array
#define PINS_COUNT           (38u)

#define analogInputToDigitalPin(p)  ((p < 6u) ? (p) + 14u : -1)

#define digitalPinToPort(P)        ( &(PORT->Group[g_APinDescription[P].ulPort]) )
#define digitalPinToBitMask(P)     ( 1 << g_APinDescription[P].ulPin )
//#define analogInPinToBit(P)        ( )
#define portOutputRegister(port)   ( &(port->OUT.reg) )
#define portInputRegister(port)    ( &(port->IN.reg) )
#define portModeRegister(port)     ( &(port->DIR.reg) )
#define digitalPinHasPWM(P)        ( g_APinDescription[P].ulPWMChannel != NOT_ON_PWM || g_APinDescription[P].ulTCChannel != NOT_ON_TIMER )

/*
 * digitalPinToTimer(..) is AVR-specific and is not defined for SAMD
 * architecture. If you need to check if a pin supports PWM you must
 * use digitalPinHasPWM(..).
 *
 * https://github.com/arduino/Arduino/issues/1833
 */
// #define digitalPinToTimer(P)

// Serial1
#define PIN_SERIAL1_RX       (0ul)
#define PIN_SERIAL1_TX       (1ul)
#define PAD_SERIAL1_TX       UART_TX_PAD_0//(UART_TX_PAD_2)
#define PAD_SERIAL1_RX       SERCOM_RX_PAD_1//(SERCOM_RX_PAD_3)


//Extern Power Switch
#define PIN_EXTERN_POWER_SWITCH		(2ul)

//Run Switch
#define PIN_RUN_SWITCH		(3ul)

//Power LED
#define PIN_POWER_RED_LED		(4ul)
#define PIN_POWER_GREEN_LED		(5ul)
#define PIN_LED_RXL          (5u)
#define PIN_LED_TXL          (5u)

//Low Power LED
#define PIN_LOW_POWER_LED		(6ul)

//Left RGB LED(Red/Green/Blue)
#define PIN_LEFT_RED_LED		(7ul)
#define PIN_LEFT_GREEN_LED		(8ul)
#define PIN_LEFT_BLUE_LED		(9ul)

//Right RGB LED(Red/Green/Blue)
#define PIN_RIGHT_RED_LED		(10ul)
#define PIN_RIGHT_GREEN_LED		(11ul)
#define PIN_RIGHT_BLUE_LED		(12ul)

//Left Motor(Forward/Reverse/Control/Count)
#define PIN_LEFT_MOTOR_FORWARD		(13ul)
#define PIN_LEFT_MOTOR_REVERSE		(14ul)
#define PIN_LEFT_MOTOR_CONTROL		(15ul)
#define PIN_LEFT_MOTOR_COUNT			(16ul)

//Right Motor(Forward/Reverse/Control/Count)
#define PIN_RIGHT_MOTOR_FORWARD		(17ul)
#define PIN_RIGHT_MOTOR_REVERSE		(18ul)
#define PIN_RIGHT_MOTOR_CONTROL		(19ul)
#define PIN_RIGHT_MOTOR_COUNT			(20ul)

//Front IR(Send/Receive)
#define PIN_FRONT_IR_SEND			(21ul)
#define PIN_FRONT_IR_RECEIVE		(22ul)

//Back IR(Send/Receive)
#define PIN_BACK_IR_SEND		(23ul)
#define PIN_BACK_IR_RECEIVE		(24ul)

//Left Line(Light/Delect)
#define PIN_LEFT_LINE_LIGHT		(25ul)
#define PIN_LEFT_LINE_DELECT	(26ul)

//Right Line(Light/Delect)
#define PIN_RIGHT_LINE_LIGHT		(27ul)
#define PIN_RIGHT_LINE_DELECT		(28ul)

//Mic
#define PIN_MIC		(29ul)

//USB
#define PIN_USB_DM          (30ul)
#define PIN_USB_DP          (31ul)

//Voltage detection
#define PIN_VOLTAGE_DELECT		(32ul)

//I2C
#define PIN_WIRE_SDA         (33u)
#define PIN_WIRE_SCL         (34u)

//SPI
#define PIN_SPI_MISO         (35u)
#define PIN_SPI_MOSI         (36u)
#define PIN_SPI_SCK          (37u)
#define PIN_SPI_POWER		(38u)
#define PERIPH_SPI           sercom4
#define PAD_SPI_TX           SPI_PAD_2_SCK_3
#define PAD_SPI_RX           SERCOM_RX_PAD_0

//Touch ID
#define PIN_LEFT_TOUCHID   (39u)
#define PIN_RIGHT_TOUCHID   (40u)

//Tone
#define PIN_TONE         (41u)


#if defined(__SAMD21J17A__) || defined(__SAMD21J18A__)

#define BOARD_EXPOWER_PORT 0
#define BOARD_EXPOWER_PIN 5


#define BOARD_LED_PORT                    1 //(0)
#define BOARD_LED_PIN                     6 //(28)

#define BOARD_LEDRX_PORT                  (0)
#define BOARD_LEDRX_PIN                   (27)

#define BOARD_LEDTX_PORT                  (0)
#define BOARD_LEDTX_PIN                   (28)

#elif defined(__SAMD21G18A__)

#define BOARD_LED_PORT                    (0)
#define BOARD_LED_PIN                     (27)

#define BOARD_LEDRX_PORT                  (0)
#define BOARD_LEDRX_PIN                   (27)

#define BOARD_LEDTX_PORT                  (1)
#define BOARD_LEDTX_PIN                   (3)


#endif


#ifdef BOARD_EXPOWER_PORT
inline void ExPower_init(void) { PORT->Group[BOARD_EXPOWER_PORT].DIRSET.reg = (1<<BOARD_EXPOWER_PIN); }
inline void ExPower_on(void) { PORT->Group[BOARD_EXPOWER_PORT].OUTSET.reg = (1<<BOARD_EXPOWER_PIN); }
inline void ExPower_off(void) { PORT->Group[BOARD_EXPOWER_PORT].OUTCLR.reg = (1<<BOARD_EXPOWER_PIN); }
#endif


#ifdef BOARD_LED_PORT
inline void LED_init(void) { PORT->Group[BOARD_LED_PORT].DIRSET.reg = (1<<BOARD_LED_PIN); }
inline void LED_on(void) { PORT->Group[BOARD_LED_PORT].OUTSET.reg = (1<<BOARD_LED_PIN); }
inline void LED_off(void) { PORT->Group[BOARD_LED_PORT].OUTCLR.reg = (1<<BOARD_LED_PIN); }
inline void LED_toggle(void) { PORT->Group[BOARD_LED_PORT].OUTTGL.reg = (1<<BOARD_LED_PIN); }
#endif




#ifdef __cplusplus
}
#endif

/*----------------------------------------------------------------------------
 *        Arduino objects - C++ only
 *----------------------------------------------------------------------------*/

#ifdef __cplusplus

/*	=========================
 *	===== SERCOM DEFINITION
 *	=========================
*/
extern SERCOM sercom0;
extern SERCOM sercom1;
extern SERCOM sercom2;
extern SERCOM sercom3;
extern SERCOM sercom4;
extern SERCOM sercom5;

extern Uart Serial;
extern Uart Serial1;

#endif

// These serial port names are intended to allow libraries and architecture-neutral
// sketches to automatically default to the correct port name for a particular type
// of use.  For example, a GPS module would normally connect to SERIAL_PORT_HARDWARE_OPEN,
// the first hardware serial port whose RX/TX pins are not dedicated to another use.
//
// SERIAL_PORT_MONITOR        Port which normally prints to the Arduino Serial Monitor
//
// SERIAL_PORT_USBVIRTUAL     Port which is USB virtual serial
//
// SERIAL_PORT_LINUXBRIDGE    Port which connects to a Linux system via Bridge library
//
// SERIAL_PORT_HARDWARE       Hardware serial port, physical RX & TX pins.
//
// SERIAL_PORT_HARDWARE_OPEN  Hardware serial ports which are open for use.  Their RX & TX
//                            pins are NOT connected to anything by default.
#define SERIAL_PORT_USBVIRTUAL      SerialUSB
#define SERIAL_PORT_MONITOR         Serial
// Serial has no physical pins broken out, so it's not listed as HARDWARE port
#define SERIAL_PORT_HARDWARE        Serial1
#define SERIAL_PORT_HARDWARE_OPEN   Serial1

#endif /* _VARIANT_ARDUINO_ZERO_SAMDJ_ */

