/**
 * \par Copyright (C), 2012-2016, MakeBlock
 * \brief   Driver for mCore Board.
 * \file    MeMCore.h
 * @author  MakeBlock
 * @version V1.0.1
 * @date    2015/11/09
 * @brief   Driver for mCore Board.
 *
 * \par Copyright
 * This software is Copyright (C), 2012-2016, MakeBlock. Use is subject to license \n
 * conditions. The main licensing options available are GPL V2 or Commercial: \n
 *
 * \par Open Source Licensing GPL V2
 * This is the appropriate option if you want to share the source code of your \n
 * application with everyone you distribute it to, and you also want to give them \n
 * the right to share who uses it. If you wish to use this software under Open \n
 * Source Licensing, you must contribute all your source code to the open source \n
 * community in accordance with the GPL Version 2 when your application is \n
 * distributed. See http://www.gnu.org/copyleft/gpl.html
 *
 * \par Description
 * This file is Hardware adaptation layer between Mbot board and all
 * MakeBlock drives
 *
 * \par History:
 * <pre>
 * `<Author>`         `<Time>`        `<Version>`        `<Descr>`
 * Mark Yan         2015/09/01     1.0.0            Rebuild the old lib.
 * Mark Yan         2015/11/09     1.0.1            fix some comments error.
 * </pre>
 */
#ifndef MeMCore_H
#define MeMCore_H

#include <Arduino.h>
#include "MeConfig.h"

#include "MeSerial.h"
#include "MeDCMotor.h"
#include "MeGearAngle.h"
#include "MeRGBLed.h"
#include "MeSoundSensor.h"
#include "MeIR.h"
#include "MeTouchSensor.h"
#include "MeLightSensor.h"
#include "MeBuzzer.h"




#if 0





#include "MeGearAngle.h"


/* Supported Modules drive needs to be added here */
#include "MeUltrasonicSensor.h"
#include "MeMbotDCMotor.h"
#include "MePotentiometer.h"
#include "MePIRMotionSensor.h"
#include "MeShutter.h"
#include "MeLineFollower.h"
#include "MeLimitSwitch.h"

//#include "MeInfraredReceiver.h"
#include "MeCompass.h"
#include "MeStepper.h"
#include "MeEncoderMotor.h"
#include "MeEncoderNew.h"
#include "MeLEDMatrix.h"
#include "MeBuzzer.h"
#include "MeFlameSensor.h"
//#include "IRremoteTools.h"

#endif

/*********************  Mbot Board GPIO Map *********************************/
#if 1
MePort_Sig mePort[15] =
{
  { NC, NC }, { NC, NC }, { NC, NC }, { NC, NC }, { NC, NC },
  { NC, NC }, { NC, NC }, { NC, NC }, { NC, NC }, { NC, NC },
  { NC, NC }, { NC, NC }, { NC, NC }, { NC, NC }, { NC, NC },
};
#endif

#endif // MeMCore_H

