#ifndef MeGearAngle_H
#define MeGearAngle_H

#include <stdint.h>
#include <stdbool.h>
#include <Arduino.h>
#include "MeConfig.h"

typedef void (*voidGSFuncPtr)(uint8_t nPin);


class MeGearAngle
{
public:
	MeGearAngle();
	~MeGearAngle();
	void setPin(uint8_t nPin);
  uint8_t getPin();
	void Begin();
	void End();
	long GetAngle();

	void ResetAngle();

  void SetDCSpeed(int16_t nSpeed);

  void SetGSCallback(voidGSFuncPtr pCallback);

  voidGSFuncPtr GetGSCallback();

  void GSCallback(uint32_t nInterID);

private:
	uint8_t nGAPin;
	bool bBegin;
	uint32_t nInterrupt;

  voidGSFuncPtr pGSCallback;
};

#if 0
#ifdef __cplusplus
extern "C" {
#endif

extern void BeginGearAngle(bool bRight);
extern void EndGearAngle(bool bRight);
extern void ResetGearAngle(bool bRight);
extern uint32_t GetGearAngle(bool bRight);


#ifdef __cplusplus
}
#endif

#endif




#endif 


